
import cadquery as cq

# Create a cylinder 
cylinder = cq.Workplane("XY").circle(20).extrude(20)

# Create a cutting tool out of an extruded rectangle 
# Position the cutting tool to cut the top 1/4 length and diameter of the cylinder
cutting_tool = cq.Workplane("XY").workplane(offset=15).rect(10, 10).extrude(5)

# Perform the cut operation
result = cylinder.cut(cutting_tool)

# Export the modified design to an STL file
result.val().exportStl("Refine_2.stl")
