
import cadquery as cq

# Parameters for the refined cylinder
diameter = 0.50  # Decreased diameter to make the object slightly smaller
height = 1.20  # Decreased height to make the object slightly smaller

# Create the refined cylinder
result = cq.Workplane("XY").circle(diameter / 2.0).extrude(height)

# Export the result to STL
result.val().exportStl("Refine_2.stl")
