
import cadquery as cq

# Define the parameters of the rectangle
length = 10.0
width = 5.0
corner_radius = 1.0

# Create the rounded rectangle
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(1.0) # extruding the rectangle to create a slab
)

# Apply rounded corners where possible
for edge in result.edges().vals():
    try:
        result = result.edges("%s" % edge).fillet(corner_radius)
    except:
        pass

# Export the result
result.val().exportStl("Generated.stl")
