
import cadquery as cq

# Parameters for the cylinder
outer_radius = 10.0  # Outer radius of the cylinder
inner_radius = 2.0  # Inner radius of the cylinder (for the hollow part)
height = 50.0  # Height of the cylinder

# Create the outer cylinder
outer_cylinder = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the inner cylinder
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

# Subtract the inner cylinder from the outer cylinder to create the hollow part
result = outer_cylinder.cut(inner_cylinder)

# Export the result
result.val().exportStl("Generated.stl")
