
import cadquery as cq

# Parameters for the cylinder
outer_radius = 1.  # Outer radius of the cylinder
inner_radius = 0.5  # Inner radius of the cylinder (for the hollow part)
height = 1.5  # Height of the cylinder

# Create the outer cylinder
outer_cylinder = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Create the inner cylinder
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

# Subtract the inner cylinder from the outer cylinder to create the hollow part
result = outer_cylinder.cut(inner_cylinder)

# Export the result
result.val().exportStl("Refine_2.stl")
