
import cadquery as cq

# Define the dimensions of the rectangle
length = 0.67
width = 0.75
thickness = 0.33

# Offset from origin to make the bounding box center in the desired position
offset_length = 0.33394160866737366 - length / 2
offset_width = 0.375 - width / 2
offset_thickness = 0.16423359513282776 - thickness / 2

# Create the rectangle and extrude it
result = (
    cq.Workplane("XY")
    .move(offset_length, offset_width)
    .rect(length, width)
    .extrude(thickness)
)

# Export the result to a STL file
result.val().exportStl("Refine_2.stl")
