
import cadquery as cq
import math

# Define the sides of the hexagon
a = 1.5

# The radius of a hexagon
r = a/math.sin(math.pi/6)
R = r - a/2
h = r * math.sin(math.pi/3)

# Draw the hexagon
result = cq.Workplane("XY").polygon(6, diameter=2*R).extrude(0.02)

# exporting the result to STL
result.val().exportStl("Refine_1.stl")
