
import cadquery as cq

# These can be modified rather than hardcoding values for each dimension.
length = 1.5  # Length of the block
width = 0.85  # Width of the block
height = 0.08  # Height of the block

# Creating a rectangular prism
result = (
    cq.Workplane("XY")
    .box(length, width, height, centered=(length/2, width/2, height/2))
)

# Exporting the result as STL file
result.val().exportStl("Refine_2.stl")
