
import cadquery as cq

# Adjust the dimensions to match the actual ones in Ground Truth data
# Define the dimensions
width = 0.356  # Adjusted width of the square to match Ground Truth data
length = 2 * width  # Length of the square

# Adjust the Bounding_Box_Center and extrusion parameters to match the Ground Truth data
# Create the square and extrude it
result = (
    cq.Workplane("XY").center(0.3056768476963043, 0.1801310032606125)
    .rect(length, width)
    .extrude(0.16921395063400269)  # Adjust the extrusion to create a 3D object to match Ground Truth data
)

# Save the output
result.val().exportStl("Refine_2.stl")
