
import cadquery as cq

# Parameters for the circle and holes
circle_dia = 10.0  # Diameter of the main circle
hole_dia = 1.0  # Diameter of the holes
hole_offset = 3.0  # Distance from the center of the circle to the center of the holes

# Create the main circle and extrude it
result = cq.Workplane("XY").circle(circle_dia / 2.0).extrude(1.0)

# Create the holes
for x in [-hole_offset, hole_offset]:
    for y in [-hole_offset, hole_offset]:
        result = result.workplane().center(x, y).hole(hole_dia)

# Export the result
result.val().exportStl("Refine_1.stl")
