
import cadquery as cq

# Define the points for the 'h' shape
points = [(0, 0), (0.75, 0), (0.75, 0.53), (0.88, 0.53), (0.88, 0.75), (0.75, 0.75), (0.75, 1.06), (0, 1.06)]

# Create the sketch
sketch = cq.Workplane("XY").polyline(points).close()

# Extrude the sketch to create the bench
modified_bench = sketch.extrude(0.12)

# Export the modified bench as STL
modified_bench.val().exportStl("Refine_2.stl")
