
import cadquery as cq

# Create a square and extrude it to create a thin box
result = cq.Workplane("XY").rect(1.5, 1.5).extrude(0.03)

# Create a tiny rectangle in the center of the square and cut through
result = result.faces(">Z").workplane().rect(0.75, 0.75).cutThruAll()

# Save the output
result.val().exportStl("Refine_1.stl")
