
import cadquery as cq

# Create a parallelogram
parallelogram = cq.Workplane("XY").polyline([(0, 0), (1.5, 0), (2, 1), (0.5, 1)]).close()

# Extrude the parallelogram
extruded = parallelogram.extrude(0.35)

# Draw a square inside the extruded parallelogram
square = extruded.faces(">Z").workplane().rect(0.75, 0.75)

# Negatively extrude the square to create a hole
result = square.cutThruAll()

# Save the output
result.val().exportStl("Refine_1.stl")

# Extracting some detail about the model
model_info = {
    'faces': result.faces().size(),
    'vertices': result.vertices().size(),
    'edges': result.edges().size(),
    'width': result.val().BoundingBox().xlen,
    'bounding_box_center': result.val().BoundingBox().center,
    'xy_aspect_ratio': result.val().BoundingBox().xlen / result.val().BoundingBox().ylen,
    'xz_aspect_ratio': result.val().BoundingBox().xlen / result.val().BoundingBox().zlen,
    'yz_aspect_ratio': result.val().BoundingBox().ylen / result.val().BoundingBox().zlen,
    'volume': result.val().Volume(),
    'surface_area': result.val().Area()
}
print(model_info)

# Refining the model with fillet
refined = result.edges(">Z").fillet(0.1)

# Save the output
refined.val().exportStl("Refine_2.stl")

# Extracting some detail about the refined model
model_info_refined = {
    'faces': refined.faces().size(),
    'vertices': refined.vertices().size(),
    'edges': refined.edges().size(),
    'width': refined.val().BoundingBox().xlen,
    'bounding_box_center': refined.val().BoundingBox().center,
    'xy_aspect_ratio': refined.val().BoundingBox().xlen / refined.val().BoundingBox().ylen,
    'xz_aspect_ratio': refined.val().BoundingBox().xlen / refined.val().BoundingBox().zlen,
    'yz_aspect_ratio': refined.val().BoundingBox().ylen / refined.val().BoundingBox().zlen,
    'volume': refined.val().Volume(),
    'surface_area': refined.val().Area()
}
print(model_info_refined)
