
import cadquery as cq

# Define the diameters of the two holes
d1 = 1.0  # Diameter of the smaller hole
d2 = d1 * 1.5  # Diameter of the larger hole

# Define the lengths of the two sections of the pipe
l1 = 0.3  # Length of the section with the smaller hole
l2 = 0.3  # Length of the section with the larger hole

# Define the thickness of the pipe wall
t = 0.1

# Create the first section of the pipe
pipe = (
    cq.Workplane("XY")
    .circle(d1 / 2.0 + t)
    .circle(d1 / 2.0)
    .extrude(l1)
)

# Create the second section of the pipe
pipe = (
    pipe.faces(">Z")
    .workplane()
    .circle(d2 / 2.0 + t)
    .circle(d2 / 2.0)
    .extrude(l2)
)

# Export the result
pipe.val().exportStl("Refine_1.stl")
