
import cadquery as cq
import math

# Define the points of the pentagon
pts = [
    (-0.38738591503351927, 0.16576644778251648),
    (-0.38738591503351927 + 0.73/2, 0.16576644778251648),
    (-0.38738591503351927 + 0.73/2 + 0.73/4, 0.16576644778251648 + 1.06/2),
    (-0.38738591503351927 + 0.73/2, 0.16576644778251648 + 1.06),
    (-0.38738591503351927, 0.16576644778251648 + 1.06),
    (-0.38738591503351927 - 0.73/4, 0.16576644778251648 + 1.06/2)
]

# Create the workplane and the pentagon
result = cq.Workplane("XY").polyline(pts).close()

# Extrude to create a 3D object
result = result.extrude(0.1)

# Export the result
result.val().exportStl("Refine_1.stl")
