
import cadquery as cq

# Define the dimensions
square_size = 10.0
rectangle_width = square_size / 5
rectangle_length = square_size
extrusion_length = 5.0

# Create the main square and extrude it
result = cq.Workplane("XY").box(square_size, square_size, extrusion_length)

# Create the rectangles and extrude them in the opposite direction
result = result.faces(">Z").workplane().rect(rectangle_width, rectangle_length).extrude(-extrusion_length)
result = result.faces(">Z").workplane().moveTo(square_size - rectangle_width, 0).rect(rectangle_width, rectangle_length).extrude(-extrusion_length)

# Export the result
result.val().exportStl("Generated.stl")
