
import cadquery as cq

# Dimensions for the block and cylinders
block_length = 25.0
block_width = 12.5
block_height = 5.0
cylinder_dia = block_length / 4
cylinder_height = block_height / 2

# Create the block
result = cq.Workplane("XY").box(block_length, block_width, block_height)

# Create the cylinders
cylinder1 = (
    cq.Workplane("XY")
    .workplane(offset=-cylinder_height)
    .moveTo(block_length / 4, block_width / 2)
    .circle(cylinder_dia / 2)
    .extrude(cylinder_height)
)
cylinder2 = (
    cq.Workplane("XY")
    .workplane(offset=-cylinder_height)
    .moveTo(3 * block_length / 4, block_width / 2)
    .circle(cylinder_dia / 2)
    .extrude(cylinder_height)
)

# Combine the block and cylinders
result = result.union(cylinder1).union(cylinder2)

# Export the result
result.val().exportStl("Refine_2.stl")
