
import cadquery as cq

# Define the points the polyline will be drawn through
pts = [
    (0, 0),
    (2, 0),
    (2, 1),
    (1, 1),
    (1, 2),
    (0, 2),
    (0, 0)
]

# Create a workplane and draw the polyline
r = cq.Workplane("front").polyline(pts)

# Draw the arc for the 'R'
r = r.moveTo(1, 1).threePointArc((1.5, 1.5), (0, 2))

# Mirror the geometry about the Y axis and extrude it into a 3D object
result = r.mirrorY().extrude(0.5)

# Export the result to STL
result.val().exportStl("Refine_1.stl")
