
import cadquery as cq

# Create the first cylinder
cylinder1 = cq.Workplane("XY").circle(10).extrude(5)

# Create the second cylinder in the middle of the first one
cylinder2 = cq.Workplane("XY").circle(5).extrude(5)

# Combine the two cylinders
result = cylinder1.cut(cylinder2)

# Cut off a small rectangle in the first cylinder, positioning it on the top face of the second cylinder
result = result.faces(">Z").workplane().rect(2, 5).cutThruAll()

# Save the output
result.val().exportStl("Generated.stl")
