
import cadquery as cq

# Define the size of the main square and the smaller square
main_square_size = 1.5
small_square_size = main_square_size / 5

# Create the main square and extrude it
result = (
    cq.Workplane("XY")
    .rect(main_square_size, main_square_size)
    .extrude(main_square_size)
)

# Create the smaller square at the top-right corner of the main square
# and negatively extrude it
result = (
    result
    .faces(">Z")
    .workplane()
    .rect(small_square_size, small_square_size, forConstruction=True)
    .vertices(">X and >Y")
    .rect(small_square_size, small_square_size)
    .cutBlind(-small_square_size)
)

result.val().exportStl("Refine_2.stl")
