
import cadquery as cq

# Updated Parameters for the ring and holes
outer_diameter = 20.0
width = 3.0
inner_diameter = outer_diameter - 2 * width
hole_diameter = 1.5

# Create the ring
ring = cq.Workplane("XY").circle(outer_diameter / 2).circle(inner_diameter / 2).extrude(width)

# Positions for the holes
hole_positions = [(0, outer_diameter / 2 - width / 2), 
                  (outer_diameter / 2 - width / 2, 0), 
                  (0, -outer_diameter / 2 + width / 2)]

# Create the holes
for pos in hole_positions:
    ring = ring.faces(">Z").workplane().center(*pos).hole(hole_diameter)

# Export the result
ring.val().exportStl("Refine_2.stl")
