
import cadquery as cq

# Create a rectangle and extrude it
result = cq.Workplane("front").rect(1, 0.73).extrude(0.75)

# Create a hollow cylinder in the middle of the rectangle
result = result.faces(">Z").workplane().circle(0.5).cutThruAll()

# Save the output
result.val().exportStl("Refine_1.stl")
