
import cadquery as cq

# Define the dimensions
original_size = 10.0
original_extrusion = 1.0
hollow_size = original_size / 2
second_size = original_size * 3 / 4
second_extrusion = original_extrusion / 4
tiny_size = 0.5
tiny_extrusion = 0.1

# Create the original rectangle and extrude it
result = cq.Workplane("XY").rect(original_size, original_size).extrude(original_extrusion)

# Create the hollow in the center
result = result.faces(">Z").workplane().rect(hollow_size, hollow_size).cutThruAll()

# Create the second rectangle on top and extrude it
result = result.faces(">Z").workplane().rect(second_size, second_size).extrude(second_extrusion)

# Create the tiny rectangles on either side and extrude them
result = result.faces(">Z").workplane().center(-second_size/4, -second_size/4).rect(tiny_size, tiny_size).extrude(tiny_extrusion)
result = result.faces(">Z").workplane().center(second_size/4, -second_size/4).rect(tiny_size, tiny_size).extrude(tiny_extrusion)

# Export the result
result.val().exportStl("Refine_1.stl")
