
import cadquery as cq

# Define the points for the pentagon
points = [(0, 0), (0.75, 0), (0.875, 0.275), (0.375, 0.55), (-0.125, 0.275)]

# Create the workplane and the pentagon
result = cq.Workplane("front").polyline(points).close()

# Extrude the pentagon to create a pentagonal prism
result = result.extrude(0.48)

# Export the result
result.val().exportStl("Refine_1.stl")
