
import cadquery as cq

# Create a rectangular sketch and extrude it
result = cq.Workplane("front").rect(1.12, 1.5).extrude(0.04)

# Add two small holes on the left side of the rectangle
result = result.faces("<X").workplane().pushPoints([(-0.56, 0.675), (-0.56, -0.675)]).hole(0.1)

# Export the result
result.val().exportStl("Refine_1.stl")
