
import cadquery as cq

# Define the radius of the original circle and the hole
circle_radius = 1.5
hole_radius = circle_radius / 2.0

# Create a workplane, draw a circle and extrude it
result = (
    cq.Workplane("XY")
    .circle(circle_radius)
    .extrude(0.11)
    # Select the top face and create a workplane on it
    .faces(">Z")
    .workplane()
    # Draw and cut the hole
    .hole(hole_radius * 2)
)

# Export the result
result.val().exportStl("Refine_1.stl")
