
import cadquery as cq

# Define the U-shape outline using a list of points
points = [(0, 0), (20, 0), (20, 2), (8, 2), (8, 10), (20, 10), (20, 20), (0, 20), (0,0)]

# Create a u_shape in a new workplane
u_shape = cq.Workplane("XY").polyline(points).close()

# Extrude the U-shape
result = u_shape.extrude(1)

# Export the result to STL
result.val().exportStl("Refine_2.stl")
