
import cadquery as cq

# Define the points of a right triangle
points = [(0, 0), (1, 0), (0, 1)]

# Generate workplane and draw the right triangle
result = cq.Workplane("XY").polyline(points).close()

# Perform marginal extrusion to create a 3D object from the right triangle
result = result.extrude(0.1)

# Export the result as an STL file
result.val().exportStl("Refine_2.stl")
