
import cadquery as cq

# Create the base square
base_square = cq.Workplane("XY").rect(10, 10).extrude(1)

# Create the smaller square on top of the base square
smaller_square = cq.Workplane("XY").workplane(offset=1).rect(8, 8).extrude(1)

# Combine the two squares
result = base_square.union(smaller_square)

# Export the result
result.val().exportStl("Generated.stl")
