
import cadquery as cq

# Define the parameters of the ring
outer_radius = 1.5 / 2
inner_radius = outer_radius - 0.01
extrude_length = 0.01

# Create the ring
result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(extrude_length)
)

# Export the result
result.val().exportStl("Refine_1.stl")
