
import cadquery as cq

# Define the parameters of the ring
outer_radius = 1.5 / 2
inner_radius = outer_radius - 0.01
extrude_length = 1.5

# Create the ring
result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(extrude_length)
)

# Export the refined result
result.val().exportStl("Refine_2.stl")
