
import cadquery as cq

# Define the dimensions
length = 1.09  # Length of the rectangle
width = 0.63  # Width of the rectangle
height = 1.5  # Height of the rectangle
cylinder_height = 1.5  # Height of the cylinder
cylinder_diameter = length / 4.0  # Diameter of the cylinder

# Create the rectangle
result = cq.Workplane("XY").box(length, width, height)

# Create the cylinder
result = result.faces(">Z").workplane().circle(cylinder_diameter / 2.0).extrude(cylinder_height)

# Export the result
result.val().exportStl("Refine_1.stl")
