
import cadquery as cq

# Define the dimensions of the steps
base_width = 0.75
base_height = 0.5
middle_width = 0.5
middle_height = 0.5
top_width = 0.25
top_height = 0.5
depth = 0.75

# Create the base of the pedestal
result = cq.Workplane("front").rect(base_width, base_height).extrude(depth)

# Create the middle step
result = result.faces(">Z").workplane().center((base_width - middle_width)/2, 0)\
         .rect(middle_width, middle_height).extrude(depth)

# Create the top step
result = result.faces(">Z").workplane().center((middle_width - top_width)/2, 0)\
         .rect(top_width, top_height).extrude(depth)

# Export the result
result.val().exportStl("Refine_1.stl")
