
import cadquery as cq

# Define the dimensions of the square and the radius of the circular cutout
square_size = 0.67
circle_radius = 0.33

# Create a workplane to draw the sketch on
result = cq.Workplane("front")

# Draw the square and extrude it
result = result.rect(square_size, square_size).extrude(1.0)

# Create the circular cutout
cutout = cq.Workplane("front").moveTo(square_size / 2, square_size / 2).circle(circle_radius).extrude(1.0)

# Cut the circle out of the square
result = result.cut(cutout)

# Save the output
result.val().exportStl("Refine_1.stl")
