
import cadquery as cq

# Create the first hexagon and extrude it
result = cq.Workplane("XY").polygon(6, 1.0).extrude(0.63)

# Create the second hexagon on top of the first and extrude it
result = result.faces(">Z").workplane().polygon(6, 0.87).extrude(0.55)

# Create the third hexagon on top of the second and extrude it
result = result.faces(">Z").workplane().polygon(6, 0.75).extrude(0.48)

# Create a triangle on top of the third hexagon and extrude it
result = result.faces(">Z").workplane().polygon(3, 0.65).extrude(0.42)

# Save the result
result.val().exportStl("Refine_1.stl")
