
import cadquery as cq

# Define the dimensions
base = 7.44
height = 16.38
thickness = 0.5

# Create the sketch
result = (
    cq.Workplane("front")
    .moveTo(0, 0)
    .lineTo(base, 0)
    .lineTo(0, height)
    .close()
    .offset2D(-thickness)
    .extrude(thickness)
)

# Export the result
result.val().exportStl("Refine_2.stl")
