
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(0.1, 0.048).extrude(0.16)

# Create the smaller rectangle on top of the base
top = cq.Workplane("XY").workplane(offset=0.16).rect(0.08, 0.038).extrude(0.16)

# Combine the two shapes
result = base.union(top)

# Export the result
result.val().exportStl("Refine_1.stl")
