
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(0.2, 0.1).extrude(0.48)

# Create the smaller rectangle on top of the base
top = cq.Workplane("XY").workplane(offset=0.48).rect(0.18, 0.08).extrude(0.48)

# Combine the two shapes
result = base.union(top)

# Export the result
result.val().exportStl("Refine_2.stl")
