
import cadquery as cq

# Define the dimensions of the trapezoid
base1 = 10.0
base2 = 20.0
height = 15.0
thickness = 5.0

# Create the trapezoid sketch
result = (
    cq.Workplane("front")
    .moveTo(-base2 / 2.0, 0)
    .lineTo(-base1 / 2.0, height)
    .lineTo(base1 / 2.0, height)
    .lineTo(base2 / 2.0, 0)
    .close()
)

# Extrude the sketch to create the prism
result = result.extrude(thickness)

# Export the result
result.val().exportStl("Generated.stl")
