
import cadquery as cq

# Create a rectangular block
block = cq.Workplane("XY").rect(0.75, 0.5).extrude(0.38)

# Create a semi-circular cutout
cutout = (
    block.faces(">Z")
    .workplane()
    .center(0, -0.25)  # Center of the semi-circle
    .split(keepTop=True)
    .circle(0.25)  # Radius of the semi-circle
    .extrude(-0.19)  # Depth of the cutout
)

# Export the result
cutout.val().exportStl("Refine_1.stl")
