
import cadquery as cq

# Define dimensions
table_height = 10.0
table_width = 4.0
table_thickness = 2.0
hole_diameter = 1.5

# Create the "U"-shaped sketch
sketch = (
    cq.Workplane("front")
    .moveTo(-table_width, 0)
    .lineTo(-table_width, table_height)
    .lineTo(table_width, table_height)
    .lineTo(table_width, 0)
    .lineTo(table_width / 2, 0)
    .lineTo(table_width / 2, table_height - table_thickness)
    .lineTo(-table_width / 2, table_height - table_thickness)
    .lineTo(-table_width / 2, 0)
    .close()
)

# Extrude the sketch to create the table
table = sketch.extrude(table_thickness)

# Create the hole in the center of the table
table_with_hole = table.faces(">Z").workplane().hole(hole_diameter)

# Export the result
table_with_hole.val().exportStl("Refine_2.stl")
