
import cadquery as cq

# Dimensions for the main plate
plate_height = 1.5  # modified based on feedback
plate_width = plate_height * (2/3)
plate_thickness = 0.078  # modified based on feedback

# Dimensions for the slot
slot_width = 0.04  # modified based on feedback
slot_height = plate_height

# Create the main plate
plate = cq.Workplane("front").box(plate_width, plate_height, plate_thickness)

# Create the slot
slot = cq.Workplane("front").workplane(offset=plate_thickness/2).rect(slot_width, slot_height).extrude(plate_thickness)

# Subtract the slot from the plate
result = plate.cut(slot)

# Export the result
result.val().exportStl("Refine_2.stl")
