
import cadquery as cq

# Parameters for the wrench
length = 0.85  # Length of the wrench
width = 0.2  # Width of the wrench
thickness = 0.2  # Thickness of the wrench
small_radius = 0.1  # Radius of the small circle
large_radius = 0.15  # Radius of the large circle
small_hole_radius = 0.05  # Radius of the small hole
large_hole_radius = 0.075  # Radius of the large hole

# Create the base rectangle
result = cq.Workplane("XY").rect(length, width)

# Add the circles at the ends
result = result.moveTo(-length / 2, 0).circle(large_radius)
result = result.moveTo(length, 0).circle(small_radius)

# Extrude the sketch
result = result.extrude(thickness)

# Create the holes
result = result.faces(">Z").workplane().center(-length / 2, 0).hole(large_hole_radius * 2)
result = result.faces(">Z").workplane().center(length / 2, 0).hole(small_hole_radius * 2)

# Export the result
result.val().exportStl("Refine_1.stl")
