
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(10, 10).extrude(5)

# Create the slot
slot = cq.Workplane("XY").workplane(offset=5).rect(5, 5).extrude(-3)

# Combine the base and the slot
result = base.cut(slot)

# Export the result
result.val().exportStl("Refine_1.stl")
