
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(1.12, 1.5).extrude(0.06)

# Create the slot
slot = cq.Workplane("XY").workplane(offset=0.06).rect(0.56, 0.75).extrude(-0.03)

# Combine the base and the slot
result = base.cut(slot)

# Export the result
result.val().exportStl("Refine_2.stl")
