
import cadquery as cq

# Dimensions for the table
table_length = 100.0
table_width = 60.0
table_thickness = 5.0
leg_length = 20.0
leg_width = 10.0
leg_height = 50.0

# Create the table top
table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Create the legs
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .rect(leg_length, leg_width)
    .extrude(leg_height)
)
leg2 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .moveTo(table_length, 0)
    .rect(leg_length, leg_width)
    .extrude(leg_height)
)
leg3 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .moveTo(0, table_width)
    .rect(leg_length, leg_width)
    .extrude(leg_height)
)
leg4 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .moveTo(table_length, table_width)
    .rect(leg_length, leg_width)
    .extrude(leg_height)
)

# Combine the table top and the legs
result = table.union(leg1).union(leg2).union(leg3).union(leg4)

# Export the result
result.val().exportStl("Generated.stl")
