
import cadquery as cq

# Create a rectangle
rectangle = cq.Workplane("front").rect(10, 2)

# Extrude the sketch
extruded = rectangle.extrude(1)

# Replace two of the longer edge's corners with rounded edges
rounded = extruded.edges("|Z").fillet(0.3)

# Verify it's a solid 3D shape
if rounded.solids().size() > 0:
    rounded = rounded.solids().first()

# Export to a STL file
rounded.val().exportStl("Refine_2.stl")
