
import cadquery as cq

# Create the base rectangle with the modified proportions
result = cq.Workplane("XY").rect(10, 10).extrude(8)

# Create the smaller rectangle on top of the base with larger height for more balanced aspect ratios
result = result.faces(">Z").workplane().rect(8, 8).extrude(8)

# Export the result
result.val().exportStl("Refine_2.stl")
