
import cadquery as cq

# Define the points for the irregular pentagon with the new dimensions
points = [(0, 0), (4, 1.5), (2, 3), (-2, 3), (-4, 1.5)]

# Create the workplane and draw the pentagon
r = cq.Workplane("front").polyline(points).close()

# Extrude the sketch to create the 3D pentagonal prism
result = r.extrude(5)

# Save the output
result.val().exportStl("Refine_2.stl")
