
import cadquery as cq

# Parameters for the box
base_width = 20.0
base_height = 10.0
base_depth = 1.0
wall_thickness = 1.0
wall_height = 10.0
chamfer_size = 0.5

# Create the base of the box
base = cq.Workplane("XY").rect(base_width, base_height).extrude(base_depth)

# Create the walls of the box
walls = (
    base.faces(">Z")
    .workplane()
    .rect(base_width - 2 * wall_thickness, base_height - 2 * wall_thickness)
    .extrude(wall_height)
)

# Notice a new condition, chamfer will now be smaller than half the shortest length
min_edge_length = min(base_width - 2 * wall_thickness, base_height - 2 * wall_thickness)
chamfer_size = min(chamfer_size, min_edge_length / 2)

# Applying chamfer to all edges of the 'walls' object
walls = walls.edges().chamfer(chamfer_size)

# Combine the base and the walls to get the final box
box = base.union(walls)

# Export the result
box.val().exportStl("Generated.stl")
